package parser;

/**
 * Factory for T1 grammar non-terminal objects.
 */
public class T1Fact extends ATVFactory {
    /**
     * Factory for T1a grammar non-terminals.
     */
    private T1aFact _t1aFact;

    /**
     * Factory for Empty grammar terminals.
     */
    private EmptyFact _emptyFact;

    /**
     * Constructor for the T1 factory,
     *
     * @param tkz       tokenizer to use
     * @param t1aFact   factory for T1a non-terminals
     * @param emptyFact factory for empty terminals
     */
    public T1Fact(ITokenizer tkz, T1aFact t1aFact, EmptyFact emptyFact) {
        super(tkz);
        _t1aFact = t1aFact;
        _emptyFact = emptyFact;
    }

    /**
     * Make a token visitor to parse an E1 non-terminal.
     *
     * @return token visitor
     */
    public ITokVisitor makeVisitor() {
        return _t1aFact.makeChainedVisitor(_emptyFact.makeVisitor());
    }

    /**
     * Make a token visitor that delegates to the given visitor in a chain of responsibility.
     *
     * @param successor visitor to serve as successor in the chain
     */
    public ITokVisitor makeChainedVisitor(ITokVisitor successor) {
        return _t1aFact.makeChainedVisitor(_emptyFact.makeChainedVisitor(successor));
    }

    /**
     * Make a token visitor that delegates to the given visitor in a chain of responsibility.
     *
     * @param successor       visitor to serve as successor in the chain
     * @param successorLambda lambda to pass to the successor in the default case
     */
    public ITokVisitor makeBacktrackChainedVisitor(ITokVisitor successor, ILambda successorLambda) {
        return _t1aFact.makeChainedVisitor(_emptyFact.makeBacktrackChainedVisitor(successor, successorLambda));
    }
}

